#include "GlobalExtern.h"
extern void ImageMenu();

void OptionInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = MAIN_MENU;
		MenuSelected = 3;
		fadeOption = 1;
		fadeColor = 255;
		MenuBackground();
		
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		OptionSelected++;
		if(OptionSelected > OptionItems.size() - 1)
			OptionSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		OptionSelected--;
		if(OptionSelected < 0)
			OptionSelected = OptionItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionSelected == 0) {
			GUIState = 4;
			return;
		}
		if(OptionSelected == 1) {
			GUIState = 5;
			return;
		}
		if(OptionSelected == 2) {
			GUIState = 7;
			return;
		}
		if(OptionSelected == 3) {
			Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
			FontSetColour(0xffffff);
			FontCenteredText(ConvertCharStringToWCHAR("Building game list..."), 320, 240, 640);
			Present();
			Scan();
			return;
		}
		if(OptionSelected == 4) {
			while(SkinMenuInput()) {
				Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
				Device->SetTexture(0,TexOption);
				DrawBackground();
				DrawSkinMenu();
				Present();
			}
			return;
		}

		if(OptionSelected == 5) {
			ImageMenu();
			return;
		}
		if(OptionSelected == 6) {
			Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
			FontSetColour(0xffffff);
			FontCenteredText(ConvertCharStringToWCHAR("Generating dat files..."), 320, 240, 640);
			Present();
			GenerateDat();
			return;
		}
	}
}

void DrawOptionItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontCenteredText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();

	if(fadeColor > 0) {
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		fade = true;
		fadeColor -=fadeSpeed;
		if(fadeColor < fadeSpeed) { fadeColor = 0; }
		Device->SetTexture(0,TexMainMenu);
		DrawBackground();
		fade = false;
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	}
	else {
		for(int i = 0; i < OptionItems.size(); i++) {
			DrawOptionItem(i, (char*)OptionItems[i].c_str(), MenuPosX, MenuPosY + (i * vSpace));
		}
	}
	Present();
}

void OptionMenu() {
	DrawOptionMenu();
	OptionInput();
}
